/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.session.backend;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.OrderedImmutableMap;
import com.floragunn.searchguard.authc.AuthInfoService;
import com.floragunn.searchguard.authc.session.backend.NoSuchSessionException;
import com.floragunn.searchguard.authc.session.backend.SessionService;
import com.floragunn.searchguard.authc.session.backend.SessionToken;
import com.floragunn.searchguard.authc.session.backend.SessionUpdateException;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.action.Action;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardRequests;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.searchsupport.cstate.metrics.Meter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentType;

public class SessionApi {

    public static class Rest
    extends RestApi {
        private static final Logger log = LogManager.getLogger(Rest.class);
        private SessionService sessionService;

        public Rest() {
            this.handlesGet("/_searchguard/auth/session/extended").with((Action)GetExtendedInfoAction.INSTANCE);
            this.handlesGet("/_searchguard/auth/session").with((r, c) -> this.handleGet((RestRequest)r, (NodeClient)c));
            this.handlesPost("/_searchguard/auth/session/with_header").with((Action)CreateAction.INSTANCE);
            this.handlesPost("/_searchguard/auth/session").with((r, c) -> this.handlePost((RestRequest)r, (NodeClient)c));
            this.handlesDelete("/_searchguard/auth/session").with((Action)DeleteAction.INSTANCE);
        }

        private BaseRestHandler.RestChannelConsumer handleGet(RestRequest request, NodeClient client) {
            return channel -> {
                try {
                    User user = (User)client.threadPool().getThreadContext().getTransient("_sg_user");
                    if (user != null) {
                        channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.OK, "application/json", DocNode.of((String)"sso_logout_url", (Object)this.sessionService.getSsoLogoutUrl(user)).toJsonString()));
                    } else {
                        channel.sendResponse(new StandardResponse(404, new StandardResponse.Error("No session")).toRestResponse());
                    }
                }
                catch (Exception e) {
                    log.warn("Error while handling request", (Throwable)e);
                    channel.sendResponse(StandardResponse.internalServerError().toRestResponse());
                }
            };
        }

        private BaseRestHandler.RestChannelConsumer handlePost(RestRequest request, NodeClient client) {
            BytesReference body = request.requiredContent();
            XContentType xContentType = request.getXContentType();
            return channel -> {
                try {
                    Map requestBody = DocReader.format((Format)Format.getByContentType((String)xContentType.mediaType())).readObject(BytesReference.toBytes((BytesReference)body));
                    this.sessionService.authenticateAndCreateSession(requestBody, request, response -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.CREATED, "application/json", response.toJsonString())), authFailureAuthzResult -> channel.sendResponse((RestResponse)new BytesRestResponse(authFailureAuthzResult.getRestStatus(), "application/json", authFailureAuthzResult.toJsonString())), e -> {
                        log.error("Error while handling request", (Throwable)e);
                        channel.sendResponse(StandardResponse.internalServerError().toRestResponse());
                    });
                }
                catch (Exception e2) {
                    log.warn("Error while handling request", (Throwable)e2);
                    channel.sendResponse(StandardResponse.internalServerError().toRestResponse());
                }
            };
        }

        public String getName() {
            return "/_searchguard/auth/session";
        }

        public SessionService getSessionService() {
            return this.sessionService;
        }

        public void setSessionService(SessionService sessionService) {
            this.sessionService = sessionService;
        }
    }

    public static class StartSessionResponse
    extends Action.Response {
        private String token;
        private String redirectUri;

        public StartSessionResponse(String token, String redirectUri) {
            this.token = token;
            this.redirectUri = redirectUri;
        }

        public StartSessionResponse(Action.UnparsedMessage message) throws ConfigValidationException {
            super(message);
            DocNode docNode = message.requiredDocNode();
            this.token = docNode.getAsString("token");
            this.redirectUri = docNode.getAsString("redirect_uri");
        }

        public String getToken() {
            return this.token;
        }

        public String getRedirectUri() {
            return this.redirectUri;
        }

        public Object toBasicObject() {
            return OrderedImmutableMap.of((Object)"token", (Object)this.token, (Object)"redirect_uri", (Object)this.redirectUri);
        }
    }

    public static class CreateAction
    extends Action<StandardRequests.EmptyRequest, StartSessionResponse> {
        public static final CreateAction INSTANCE = new CreateAction();
        public static final String NAME = "cluster:admin:searchguard:session/create";

        protected CreateAction() {
            super(NAME, StandardRequests.EmptyRequest::new, StartSessionResponse::new);
        }

        public static class Handler
        extends Action.Handler<StandardRequests.EmptyRequest, StartSessionResponse> {
            private static final Logger log = LogManager.getLogger(Handler.class);
            private final SessionService sessionService;
            private final AuthInfoService authInfoService;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, SessionService sessionService, AuthInfoService authInfoService, PrivilegesEvaluator privilegesEvaluator) {
                super((Action)INSTANCE, handlerDependencies);
                this.sessionService = sessionService;
                this.authInfoService = authInfoService;
            }

            protected final CompletableFuture<StartSessionResponse> doExecute(StandardRequests.EmptyRequest request) {
                User user = this.authInfoService.getCurrentUser();
                if (user == null) {
                    log.error("Cannot create session: No user found in thread context");
                    CompletableFuture<StartSessionResponse> result = new CompletableFuture<StartSessionResponse>();
                    result.completeExceptionally(new Exception("Invalid authentication"));
                    return result;
                }
                return this.sessionService.createSession(user);
            }
        }
    }

    public static class DeleteAction
    extends Action<StandardRequests.EmptyRequest, StandardResponse> {
        public static final DeleteAction INSTANCE = new DeleteAction();
        public static final String NAME = "cluster:admin:searchguard:session/_own/delete";

        protected DeleteAction() {
            super(NAME, StandardRequests.EmptyRequest::new, StandardResponse::new);
        }

        public static class Handler
        extends Action.Handler<StandardRequests.EmptyRequest, StandardResponse> {
            private static final Logger log = LogManager.getLogger(Handler.class);
            private final SessionService sessionService;
            private final AuthInfoService authInfoService;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, SessionService sessionService, AuthInfoService authInfoService, PrivilegesEvaluator privilegesEvaluator) {
                super((Action)INSTANCE, handlerDependencies);
                this.sessionService = sessionService;
                this.authInfoService = authInfoService;
            }

            protected final CompletableFuture<StandardResponse> doExecute(StandardRequests.EmptyRequest request) {
                User user = this.authInfoService.getCurrentUser();
                return this.supplyAsync(() -> {
                    String authTokenId = null;
                    try {
                        if (authTokenId == null && "session".equals(user.getType())) {
                            authTokenId = String.valueOf(user.getSpecialAuthzConfig());
                        }
                        if (authTokenId == null) {
                            return new StandardResponse(400, new StandardResponse.Error("User has no active session"));
                        }
                        SessionToken authToken = this.sessionService.getByIdFromIndex(authTokenId, Meter.NO_OP);
                        if (!user.getName().equals(authToken.getUserName())) {
                            throw new NoSuchSessionException(authTokenId);
                        }
                        String status = this.sessionService.delete(user, authToken);
                        return new StandardResponse(200, status);
                    }
                    catch (NoSuchSessionException e) {
                        return new StandardResponse(404, new StandardResponse.Error("No such auth token: " + authTokenId));
                    }
                    catch (SessionUpdateException e) {
                        log.error("Error while updating " + authTokenId, (Throwable)e);
                        return new StandardResponse(500, new StandardResponse.Error(e.getMessage()));
                    }
                });
            }
        }
    }

    public static class GetExtendedInfoAction
    extends Action<StandardRequests.EmptyRequest, Response> {
        public static final GetExtendedInfoAction INSTANCE = new GetExtendedInfoAction();
        public static final String NAME = "cluster:admin:searchguard:session/_own/get/extended";

        protected GetExtendedInfoAction() {
            super(NAME, StandardRequests.EmptyRequest::new, Response::new);
        }

        public static class Handler
        extends Action.Handler<StandardRequests.EmptyRequest, Response> {
            private final SessionService sessionService;
            private final AuthInfoService authInfoService;

            @Inject
            public Handler(Action.HandlerDependencies handlerDependencies, SessionService sessionService, AuthInfoService authInfoService) {
                super((Action)INSTANCE, handlerDependencies);
                this.sessionService = sessionService;
                this.authInfoService = authInfoService;
            }

            protected final CompletableFuture<Response> doExecute(StandardRequests.EmptyRequest request) {
                User user = this.authInfoService.getCurrentUser();
                if (user == null) {
                    CompletableFuture<Response> result = new CompletableFuture<Response>();
                    result.completeExceptionally(new Exception("No user present"));
                    return result;
                }
                return CompletableFuture.completedFuture(new Response(user, this.sessionService.getSsoLogoutUrl(user)));
            }
        }

        public static class Response
        extends Action.Response {
            private String userName;
            private String userSubName;
            private String userType;
            private List<String> userRoles;
            private List<String> userSearchGuardRoles;
            private Map<String, Object> userAttributes;
            private String userRequestedTenant;
            private String ssoLogoutUrl;

            public Response(User user, String ssoLogoutUrl) {
                this.userName = user.getName();
                this.userSubName = user.getSubName();
                this.userType = user.getType();
                this.userRoles = ImmutableList.of(user.getRoles());
                this.userSearchGuardRoles = ImmutableList.of(user.getSearchGuardRoles());
                this.userAttributes = user.getStructuredAttributes();
                this.userRequestedTenant = user.getRequestedTenant();
                this.ssoLogoutUrl = ssoLogoutUrl;
            }

            public Response(Action.UnparsedMessage message) throws ConfigValidationException {
                super(message);
                DocNode docNode = message.requiredDocNode();
                DocNode userNode = docNode.getAsNode("user");
                this.userName = userNode.getAsString("name");
                this.userSubName = userNode.getAsString("sub_name");
                this.userType = userNode.getAsString("type");
                this.userRoles = userNode.getAsListOfStrings("backend_roles");
                this.userSearchGuardRoles = userNode.getAsListOfStrings("search_guard_roles");
                this.userAttributes = userNode.getAsNode("attributes").toMap();
                this.userRequestedTenant = userNode.getAsString("requested_tenant");
                this.ssoLogoutUrl = docNode.getAsString("sso_logout_url");
            }

            public Object toBasicObject() {
                return OrderedImmutableMap.of((Object)"user", (Object)OrderedImmutableMap.of((Object)"name", (Object)this.userName, (Object)"sub_name", (Object)this.userSubName, (Object)"type", (Object)this.userType, (Object)"backend_roles", this.userRoles, (Object)"search_guard_roles", this.userSearchGuardRoles).with((Object)"attributes", this.userAttributes).with((Object)"requested_tenant", (Object)this.userRequestedTenant), (Object)"sso_logout_url", (Object)this.ssoLogoutUrl);
            }
        }
    }
}

